#ifndef ENV_MESSAGE_H
#define ENV_MESSAGE_H

#include <Looper.h>
#include "Message.h"

// Class supporting messages sent to the environment through the BLooper construct
// (not port-based messages).

// Message types
enum {
	// perception & action messages
	RATMSG_IS_OPEN = 0,
	RATMSG_MOVE,
	RATMSG_EATFOOD,
	RATMSG_FOODHERE,
	RATMSG_ROTATE,
	RATMSG_LOOK,
	
	USERMSG_IS_ARBITRARY_DOOR_OPEN, 
	USERMSG_PLACE_FOOD,
	USERMSG_REMOVE_FOOD,
	USERMSG_OPEN_DOOR,
	USERMSG_CLOSE_DOOR,
	USERMSG_WARP_TO,
	USERMSG_IS_FOOD_AT_LOCATION,
	USERMSG_GET_RAT_LOCATION,
	USERMSG_SET_NUMBER_OF_ARMS,
	USERMSG_GET_NUMBER_OF_ARMS,
	USERMSG_GET_CURR_HEADING,
	USERMSG_RESET_DISPLAY_CHANGE,
	USERMSG_GET_DISPLAY_CHANGE
};

//class Environment;

class EnvMessage : public Message {
	public:
		// This is a BLooper object pointer right now. We don't want extra hooks
		// into BeOS right now, but we need a way to take hooks from server internals
		// of system to enable plugins to compile standalone.
		EnvMessage(BLooper *env) {this->env = env;}
		int Ver(); // return API version
	protected: // data members
		BLooper *env;
};

//#include "Environment.h"

#endif ENV_MESSAGE_H